
function controlsSetup()
{
	bufferTime = 5;
	
	jumpKeyBuffered = 0;
	jumpKeyBufferTimer = 0;
}

function getControls()
{
	//Direkcijas ievade
	rightkey = keyboard_check( vk_right ) + keyboard_check( ord("D"));
		rightkey = clamp ( rightkey, 0, 1)
	
	leftkey = keyboard_check( vk_left ) + keyboard_check (ord("A"));
		leftkey = clamp ( leftkey, 0, 1)
	
	//Darbības ievade
	jumpKeyPressed = keyboard_check_pressed( vk_space );
	
	jumpKey = keyboard_check( vk_space );
	
	if jumpKeyPressed
	{
		jumpKeyBufferTimer = bufferTime;
	}
	if jumpKeyBufferTimer > 0
	{
		jumpKeyBuffered = 1;
		jumpKeyBufferTimer--;
	} else {
		jumpKeyBuffered = 0;
	}
}

function save_game() {
    var save_file = "save_game.ini";
    ini_open(save_file);

    // Save player position
    ini_write_real("Player", "x", oPlayer.x);
    ini_write_real("Player", "y", oPlayer.y);

    // Save final time (only if it's set)
    if (variable_global_exists("final_time")) {
        ini_write_real("Player", "final_time", global.final_time);
    }

    // Save player name
    ini_write_string("Player", "name", global.player_name);

    // Save current time
    ini_write_real("Player", "current_time", current_time);

    ini_close();
    show_message("Game Saved Successfully!");
}

function load_game() {
    var save_file = "save_game.ini";

    if (file_exists(save_file)) {
        ini_open(save_file);

        // Load player position into temporary global variables
        global.load_player_x = ini_read_real("Player", "x", 0);
        global.load_player_y = ini_read_real("Player", "y", 0);

        // Load final time (if it exists)
        if (ini_key_exists("Player", "final_time")) {
            global.final_time = ini_read_real("Player", "final_time", 0);
        }

        // Load player name
        global.player_name = ini_read_string("Player", "name", "Player");

        // Load current time
        global.current_time = ini_read_real("Player", "current_time", 0);

        ini_close();
        show_message("Game Loaded Successfully!");

        return true; // Indicate that the game was loaded successfully
    } else {
        show_message("No save file found!");
        return false; // Indicate that the game was not loaded
    }
}






